#version 330
#extension GL_EXT_gpu_shader4 : enable
//dangerous curvesMod01.fsh  by   jorge2017a1
//https://www.shadertoy.com/view/ssXSzf
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//por jorge2017a1-
// referencia 
//----------------- pjkarlik 
//-----------------FabriceNeyret2-----helix
//https://www.shadertoy.com/view/tdVyzV

#define MAX_STEPS 100
#define MAX_DIST 110.
#define MIN_DIST 0.001
#define EPSILON 0.001
#define REFLECT 2

///------------------------------------
struct TObj
{
    float id_color;
    float id_objeto;
    float id_material;
    float dist;
    vec3 normal;
    vec3 ro;
    vec3 rd;
    vec2 uv;
    vec3 color;
    vec3 p;
    vec3 phit; //22-mar-2021
    vec3 rf;
    float marchCount;
    bool blnShadow;
    bool hitbln;
};

    
TObj mObj;
vec3 glpRoRd;
vec2 gres2;
float itime;

#define PI 3.14159265358979323846264
#define MATERIAL_NO -1.0
#define COLOR_NO -1.0
#define COLORSKY vec3(0.1, 0.1, 0.6)


float random() 
{ return fract(sin(dot(mObj.uv, vec2(12.9898, 78.233)) ) * 43758.5453); }

vec3 checkerBoard(float u, float v, float interval)
{
    float uu = floor(u/interval*2.0);
    float vv = floor(v/interval*2.0);
    float p =mod(uu+vv,2.0);
    return vec3(0.1+0.9*p);
}


vec3  Arrcolores[] = vec3[] (
vec3(0,0,0)/255.0,  //0
vec3(255.,255.,255.)/255.0, //1
vec3(255,0,0)/255.0,  //2
vec3(0,255,0)/255.0,   //3
vec3(0,0,255)/255.0,   //4
vec3(255,255,0)/255.0,  //5
vec3(0,255,255)/255.0,  //6 
vec3(255,0,255)/255.0,   //7
vec3(192,192,192)/255.0,  //8
vec3(128,128,128)/255.0,  //9
vec3(128,0,0)/255.0,   //10
vec3(128,128,0)/255.0,  //11
vec3(0,128,0)/255.0,   //12
vec3(128,0,128)/255.0,  //13
vec3(0,128,128)/255.0,  //14
vec3(0,0,128)/255.0,    //15
vec3(255, 204, 188)/255.0,  //16
vec3(0.8, 0.8, 0.8),  //17
vec3(0.5, 0.5, 0.8),  //18
vec3(1, 0.5, 0),      //19
vec3(1.0, 1.0, 1.0),  //20
vec3(247./255., 168./255.,  184./255.),  //21
vec3(0, 1, 1),                           //22 
vec3(85./255., 205./255., 252./255.),    //23
vec3(0.425, 0.56, 0.9)*vec3( 0.3, 0.2, 1.0 ),  //24 
vec3(0.8,0.8,0.8)*vec3( 0.3, 0.2, 1.0 ),       //25  
vec3(1.0,0.01,0.01)*vec3( 0.3, 0.2, 1.0 ),     //26
vec3(0.1, 0.5, 1.0),                           //27   
vec3(0.0, 0.6, 0.0),                       //28 
vec3(0.1,0.1,0.7),                          //29
vec3(0.99, 0.2, 0.1), //30
vec3(.395, .95, 1.), //31
vec3(0.425, 0.56, 0.9) 
);

//----------------------------------------------------
vec3 getColor(int i)
{    
    if (i==-2 ) {return mObj.color; }       
    if (i>-1 ) 
		return Arrcolores[i];
}
///--------------------------------------------


vec3 GetColorYMaterial(vec3 p,  vec3 n, vec3 ro,  vec3 rd, int id_color, float id_material);
vec3 getMaterial( vec3 pp, float id_material);

//append 


vec3 light_pos1;  vec3 light_color1 ;
vec3 light_pos2;  vec3 light_color2 ;

//operacion de Union  por FabriceNeyret2
#define opU3(d1, d2) ( d1.x < d2.x ? d1 : d2 )
#define opU(d1, d2) ( d1.x < d2.x ? d1 : d2 )

float sdSphere( vec3 p, float s )
	{ return length(p)-s;}
float sdBox( vec3 p, vec3 b )
	{ vec3 d = abs(p) - b;   return length(max(d,0.0))+ min(max(d.x,max(d.y,d.z)),0.0); }

//----------oPeraciones de Repeticion
float opRep1D( float p, float c )
	{ float q = mod(p+0.5*c,c)-0.5*c; return  q ;}
///------------------------------------
// object transformation
vec3 rotate_x(vec3 p, float phi)
{
    float c = cos(phi);	float s = sin(phi);
    return vec3(p.x, c*p.y - s*p.z, s*p.y + c*p.z);
}
vec3 rotate_y(vec3 p, float phi)
{
	float c = cos(phi);	float s = sin(phi);
	return vec3(c*p.x + s*p.z, p.y, c*p.z - s*p.x);
}
vec3 rotate_z(vec3 p, float phi)
{
	float c = cos(phi);	float s = sin(phi);
	return vec3(c*p.x - s*p.y, s*p.x + c*p.y, p.z);
}
///------------------------------------
vec2 rotatev2(vec2 p, float ang)
{
    float c = cos(ang);
    float s = sin(ang);
    return vec2(p.x*c - p.y*s, p.x*s + p.y*c);
}

// path functions 
vec2 path(in float z)
{ 
    vec2 p1 =vec2(2.13*sin(z * .15), 1.74*cos(z * .085));
    vec2 p2 =vec2(2.97*sin(z * .079), 1.23*sin(z * .127));
    return p1 - p2;
}
// Repeat space along one axis.
float pMod(inout float p, float size) {
    float halfsize = size*0.5;
    float c = floor((p + halfsize)/size);
    p = mod(p + halfsize, size) - halfsize;
    return c;
}

vec3 Helix(vec3 p)
{
    vec3 res= vec3(9999.0, -1.0,-1.0);
    vec3 q = p;
    float l = length(q.xy)-8.0;
    float d = sin(atan(q.y,q.x)-q.z);           // sin: double
    float td = length(vec2(l-15.,d)) - 0.35;        // double-spring
    res =opU3(res, vec3(td,7.0,-1.0)); 
    return res;
}  
///------------------------------------
vec3 GetDist(vec3 p  ) 
{	vec3 res= vec3(9999.0, -1.0,-1.0);
    vec3 pp=p;
	float planeDist1 = p.y+0.0;  //piso inf
    
   ///https://www.shadertoy.com/view/tdVyzV
   p.y=p.y-5.0;
   vec2 qath = p.xy - path(p.z);
   vec3 q = vec3(qath,p.z);
   vec3 dq = q;
   
    vec3 r = dq;
    pMod(r.z,3.);
    vec3 r2=r;
    vec3 r3=r;
    
   
    r = vec3(abs(r.x)-10.0,r.y-3.5,r.z);
    r2 = vec3(abs(r2.x)-10.0,r2.y-1.0,r2.z);
    r3 = vec3(r3.x,r3.y+1.0,r.z);
    
   float pared1= sdBox( r, vec3(1.0,2.0,10.0) );
   float pared2= sdBox( r, vec3(1.0,2.0,10.0) );
   float banqueta= sdBox(r2, vec3(3.0,1.0,10.0) );
   float calle= sdBox(r3, vec3(10.0,1.0,10.0) );
   
   dq.x=abs(dq.x)- 11.0;
   dq.y-=5.0;
   dq.z= opRep1D( dq.z, 10.0 );
   float poste= sdBox( dq, vec3(1.0,5.0,2.0) );
   res =opU3(res, vec3(poste,8.0,-1.0));
    
     vec3 h1= Helix(r3-vec3(0.0,0.0,.0));
   
   res =opU3(res, vec3(pared1,3.0,-1.0));
   res =opU3(res, vec3(pared2,3.0,-1.0));
   res =opU3(res, vec3(banqueta,5.0,-1.0));
   res =opU3(res, vec3(calle,-1.0,6.0));
   
   res =opU3(res, h1);
        //res =opU3(res, vec3(1.0,0.0,MATERIAL_NO)); 
    //return (dist, id_color, id_material)
    return res;
}

//------------------------------------------------
vec3 GetNormal(vec3 p)
{
	float d = GetDist(p).x;
    vec2 e = vec2(.001, 0);
    vec3 n = d - vec3(
        GetDist(p-e.xyy).x,
        GetDist(p-e.yxy).x,
        GetDist(p-e.yyx).x);
    return normalize(n);
}

float RayMarch(vec3 ro, vec3 rd, int PMaxSteps)
{
    float dO = 0.; 
    vec3 dS=vec3(9999.0,-1.0,-1.0);
    float marchCount = 0.0;
    vec3 p;
    float minDist = 9999.0; 
    
    for(int i=0; i <= PMaxSteps; i++) 
    {  	p = ro + rd*dO;
        dS = GetDist(p);
        if ( abs(dS.x)<MIN_DIST  || i == PMaxSteps)
        {   mObj.hitbln = true; minDist = abs(dO); break; }
        
        if(dO>MAX_DIST)
        { mObj.hitbln = false;    minDist = dO;    break; } 
        dO += dS.x;
        marchCount++;
    }
    mObj.dist = minDist;
    mObj.id_color = dS.y;
    mObj.marchCount=marchCount;
    mObj.id_material=dS.z;
    mObj.normal=GetNormal(p);
    mObj.phit=p;
    return dO;
}
//---------------------------------------------------
float GetShadow(vec3 p, vec3 plig)
{
    vec3 lightPos = plig;
    vec3 l = normalize(lightPos-p);
    vec3 n = GetNormal(p);
    float dif = clamp(dot(n, l), 0., 1.);
    float d = RayMarch(p+n*MIN_DIST*2., l , MAX_STEPS/2);
    if(d<length(lightPos-p)) dif *= .1;
    return dif;
}

///============================================================

vec3 amb(vec3 c, float k)
{  return c * k; }

float diff(vec3 p,vec3 lp,vec3 n )
{   vec3 l = normalize(lp - p);
    float dif = clamp(dot(l, n), 0.0, 1.0);
    return dif;
}
float spec( vec3 p, vec3 lp,vec3 rd,vec3 n )
{   vec3 l = normalize(lp - p);
    vec3 r = reflect(-l, n);
    float spe =pow(clamp(dot(r, -rd), 0.0, 1.0), 8.0);
    return spe;
}

vec3 lightingv3(vec3 normal,vec3 p, vec3 lp, vec3 rd, vec3 ro,vec3 col) 
{
    vec3 l = lp - p;
    vec3 ldir = normalize(p-rd);
    
    float dist = max(length(l), 0.01);
    float atten = min(1./(1. + dist*0.5), 0.2);
    l /= dist;
    
    vec3 n = normal;
   	vec3 r = reflect(-l, n);
    
    vec3 amb=amb(col, 0.5);
    float dif = diff( p, lp, n );
    float diff=max(0.,dot(ldir,-n));
    vec3 ln=normalize(lp);
    
    float spe= spec(  p,  lp, rd, n );
    float fre = pow(clamp(1.0 + dot(n, rd), 0.0, 1.0), 2.0);
    float dom = smoothstep(-1.0, 1.0, r.y);
     float bac=clamp(dot(n,-l),0.0,1.0);
    float rim=pow(1.0+dot(n,rd),3.0);
    float dn=.15*max(0.,dot(normalize(rd),-n));
    
    float fshadow;
    float sh = clamp(dot(n,normalize(lp)),0.0,1.0);
    
    
    if (mObj.blnShadow==true)
    { fshadow=GetShadow(p,lp);}
    else
    {   fshadow=0.5; }

    
    vec3 lin = amb;
    lin += 1.0*(dif+diff)*sh;
    lin += 2.5*spe;
    lin += 2.5*fre*vec3(1.);
    lin += 0.5*dom*vec3(1.);
    lin += 0.35*bac*vec3(1.);
    lin += 0.35*rim*vec3(1.);
    lin += 0.35*rim*dn*vec3(1.);
    
    lin *= atten*0.8*col*fshadow;
    lin = pow(lin,vec3(0.4545));
  return lin;
    
}
///============================================================
vec3 Getluz(vec3 p, vec3 ro, vec3 rd, vec3 nor , vec3 colobj ,vec3 plight_pos)
{
    float intensity=1.0;
     vec3 result;
     
    result = lightingv3( nor, p, plight_pos,  rd,ro, colobj);
    return result;
}
///-------------------------------------


vec3 render_sky_color(vec3 rd)
{   float t = (rd.x + 1.0) / 2.0;
    vec3 col= vec3((1.0 - t) + t * 0.3, (1.0 - t) + t * 0.5, (1.0 - t) + t);
 	vec3  sky = mix(vec3(.0, .1, .4)*col, vec3(.3, .6, .8), 1.0 - rd.y);
	return sky;
}
//------------------------------------------------
vec3 getMaterial( vec3 pp, float id_material)
{
  vec3 col=vec3(1.0);
  vec3 p=pp;
  vec3 l1;
    
    if (id_material==5.0)
    {
        float escala=0.25;
    	float d = mod(floor(p.x*escala)+floor(p.z*escala*2.0),2.0);
	    return vec3( clamp(d,0.0,1.0) );
    }
    
    
    if (id_material==6.0)
    {
        float escala=0.25;
    	float d = mod(floor(p.x*escala)+floor(p.z*escala*2.0),2.0);
	    vec3 col= vec3( clamp(d,0.0,1.0) );
              l1= amb(col, 0.5) + col*diff( p,light_pos1, mObj.normal) + col*spec( p, light_pos1,mObj.rd, mObj.normal);
        return l1;
    }
 }
//-------------------------------------------------
vec3 GetColorYMaterial(vec3 p,  vec3 n, vec3 ro,  vec3 rd, int id_color, float id_material)
{
   	vec3 colobj; 
     if (id_color<100)
		{ colobj=getColor(int( id_color)); }
 

    if (id_material>-1.0 && id_color==-1)
        { 
            colobj=vec3(0.5);
            colobj*=getMaterial(p, id_material); 
            return colobj;
        }
    return colobj;
}

///---------------------------------------------
vec3 linear2srgb(vec3 c) {
    return mix(
        12.92 * c,
        1.055 * pow(c, vec3(1.0/2.4)) - 0.055,
        step(vec3(0.0031308), c)
    );
}

vec3 exposureToneMapping(float exposure, vec3 hdrColor) 
{    return vec3(1.0) - exp(-hdrColor * exposure);  }

vec3 Render(vec3 ro, vec3 rd)
{
  vec3 col = vec3(0);
   TObj Obj;
   mObj.rd=rd;
   mObj.ro=ro;
   vec3 p ;

   float d=RayMarch(ro,rd, MAX_STEPS);
   
    Obj=mObj;
    if(mObj.hitbln) 
    {
        p = (ro + rd * d );  
         
         
        vec3 nor=mObj.normal;

        vec3 colobj;
        colobj=GetColorYMaterial( p, nor, ro, rd,  int( Obj.id_color), Obj.id_material);

        float dif1=1.0;
        vec3 result;
        result=  Getluz( p,ro,rd, nor, colobj ,light_pos1);
        result+= Getluz( p,ro,rd, nor, colobj ,light_pos2);
        col= result;
        col=linear2srgb(col);
    }
    else if(d>MAX_DIST)
    col= render_sky_color(rd);
   
   return col;
}



///---------------------------------------------
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
   vec2 uv = (gl_FragCoord.xy -.5*iResolution.xy)/iResolution.y;
   mObj.uv=uv;
    float t;
    t=mod(iTime*12.0,1000.0);
    itime=t;
	//mObj.blnShadow=false;
    mObj.blnShadow=true;
        
 	light_pos1= vec3(5.0, 10.0, -10.0 ); light_color1=vec3( 1.0 );
 	light_pos2= vec3( 0.0, 10.0, 10.0 ); light_color2 =vec3( 1.0 ); 
 
   
   vec3 ro=vec3(0.0,7.0,-25.0+t);
   ro.xy += path(ro.z);
   vec3 rd=normalize( vec3(uv.x,uv.y,1.0));
      
   
    light_pos1+=ro;
    light_pos2+=ro;
    vec3 col= Render( ro,  rd);
    gl_FragColor = vec4(col,1.0);
}
